import QtQuick 2.3
import AdaptDemoSystem 1.0

DrawMesh {
    id: sel
    name: "meshSel"
    enabled: name!=="meshSel"
    property int ind: name!=="meshSel" ? sync(sel.name+".meshIndex") : 0
    property int count: contList.length
    property string prefix: "mesh/"

    depthTest: true
    depthWrite: true

    property variant contList: [
        "adapt.obj", //0
        "adaptknivv_kolmio.lwo", //1
        "tri4.lwo", //2
        "hand.x", //3
        "octa.lwo", //4
        "kolkkus.x", //5
        "adaptmeshtri.lwo", //6
        "longhand.x", //7
    ]

    file: prefix+(ind < contList.length ? contList[ind] : contList[0])
}

